/*
	File:		BaseDialog.cp

	Contains:	Base class for a dialog.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

#include <Dialogs.h>
#include "BaseDialog.h"

BaseDialog::BaseDialog()
{
}

BaseDialog::BaseDialog( SInt16 resID )
{
	fWindow = GetNewDialog( resID, NULL, (WindowPtr)-1L );
	if ( fWindow )
	{
		((WindowPeek)fWindow)->windowKind = 2000;
		SetWRefCon( fWindow, (long)this );
	}
}

BaseDialog::~BaseDialog()
{
	if ( fWindow )
	{
		DisposeDialog( fWindow );
		fWindow = nil;
	}
}

void
BaseDialog::Update( EventRecord& event )
{
	DialogPtr		dialog;
	SInt16			itemHit;

	((WindowPeek)fWindow)->windowKind = dialogKind;
	DialogSelect( &event, &dialog, &itemHit );
	((WindowPeek)fWindow)->windowKind = 2000;
}

void
BaseDialog::Activate( EventRecord& event )
{
	DialogPtr		dialog;
	SInt16			itemHit;
	
	((WindowPeek)fWindow)->windowKind = dialogKind;
	DialogSelect( &event, &dialog, &itemHit );
	((WindowPeek)fWindow)->windowKind = 2000;
}

void
BaseDialog::Deactivate( EventRecord& event )
{
	DialogPtr		dialog;
	SInt16			itemHit;
	
	((WindowPeek)fWindow)->windowKind = dialogKind;
	DialogSelect( &event, &dialog, &itemHit );
	((WindowPeek)fWindow)->windowKind = 2000;
}

void
BaseDialog::HandleClick( EventRecord& event )
{
	DialogRef		dialog;
	SInt16			itemHit;
	
	if ( DialogSelect( &event, &dialog, &itemHit ) )
	{
		HandleItemHit( itemHit );
	}
}

void
BaseDialog::HandleKeyDown( EventRecord& event )
{
	DialogPtr		dialog;
	SInt16			itemHit;
	
	((WindowPeek)fWindow)->windowKind = dialogKind;
	DialogSelect( &event, &dialog, &itemHit );
	((WindowPeek)fWindow)->windowKind = 2000;
}


void
BaseDialog::HandleItemHit( short /*itemHit*/ )
{
}
